-- Teleport Stone v1.1
-- by _Q_
-- graphics by Raccoon Superhero
-- Mark location with teleport stone, and recall to that location at later time. 
-- Teleporting will cost you 30 sanity or 25 health and 20% of the stone.
-- Mark and reset actions don't have any cost. 
-- You can reset marked location by holding Ctrl key and right clicking over teleport stone.
-- You can recharge teleport stone with nightmare fuel.
-- To craft the stone you need 15x nightmare fuel, purple gem and shadow manipulator.
-- 14.07.2013 
-- Thanks to Heavenfall, zeidrich,  no_signal for help with the code.

Ingredient = GLOBAL.Ingredient
RECIPETABS = GLOBAL.RECIPETABS
STRINGS = GLOBAL.STRINGS
ACTIONS = GLOBAL.ACTIONS
TECH = GLOBAL.TECH

TUNING.BLACKSTONE_USES = 5
STRINGS.NAMES.BLACKSTONE = "Void Stone"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLACKSTONE = "It speaks to me."  
STRINGS.RECIPE_DESC.BLACKSTONE = "Bend space and time."
STRINGS.ACTIONS.MARK = "Mark"      
STRINGS.ACTIONS.RECALL = "Recall"
STRINGS.ACTIONS.RESET = "Reset"
STRINGS.ACTIONS.RECHARGE = "Recharge"

PrefabFiles = 
{
	"blackstone",
}

Assets = 
{
	--Asset("ANIM", "anim/blstone.zip"),
	--Asset("IMAGE", "images/inventoryimages/blackstone.tex"),
	Asset("ATLAS", "images/inventoryimages/blackstone.xml"),
	--Asset("IMAGE", "images/inventoryimages/blackstone_r.tex"), 
	--Asset("ATLAS", "images/inventoryimages/blackstone_r.xml"),
}

function blackstone()

local blackstone = GLOBAL.Recipe("blackstone", {Ingredient("nightmarefuel", 15), Ingredient("purplegem", 1)}, RECIPETABS.MAGIC,  TECH.MAGIC_THREE)
blackstone.atlas = "images/inventoryimages/blackstone.xml"

end

AddGamePostInit(blackstone)

local function NightmareFuelPostInit(inst)
    inst:AddComponent("recharger")
	inst.components.recharger.rechargevalue = 1 
	inst.components.recharger.rechargematerial = "nightmarefuel"
end

AddPrefabPostInit("nightmarefuel", NightmareFuelPostInit)

function StoneSimPostInit()

ACTIONS.RECHARGE = GLOBAL.Action()
ACTIONS.RECHARGE.fn = function(act)
	if act.target and act.target.components.finiteuses and act.invobject and act.invobject.components.recharger then
		return act.invobject.components.recharger:StoneRecharge(act.target, act.doer)
	end
end

ACTIONS.RESET = GLOBAL.Action()
ACTIONS.RESET.fn = function(act)
 local tar = act.target or act.invobject
  if tar and tar.components.telestone and tar.components.telestone:IsMarked() or tar.components.telestone:IsMarkedCave() then
            tar.components.telestone:Reset(tar)
        return true
    end
end

ACTIONS.MARK = GLOBAL.Action()
ACTIONS.MARK.fn = function(act)
 local tar = act.target or act.invobject
  if tar and tar.components.telestone and not tar.components.telestone:IsMarked() or not tar.components.telestone:IsMarkedCave() then
        tar.components.telestone:Mark(tar)
        return true
    end
end

ACTIONS.RECALL = GLOBAL.Action()
ACTIONS.RECALL.fn = function(act)
  local tar = act.target or act.invobject
   if tar and tar.components.telestone and tar.components.telestone:IsMarked() or tar.components.telestone:IsMarkedCave() then
             tar.components.telestone:Recall(act.doer)
         return true
     end
end
 
for k,v in pairs(ACTIONS) do
	if (k == "MARK" or k == "RECALL" or k == "RESET" or k == "RECHARGE") then
    		v.str = STRINGS.ACTIONS[k] or "ACTION"
   		 v.id = k
	 end
end

local function addActionHandler(SGname, action, state, condition)
	actionHandler = GLOBAL.ActionHandler(action, state, condition)
	for k,v in pairs(GLOBAL.SGManager.instances) do	
		if(k.sg.name == SGname) then
			k.sg.actionhandlers[action] = actionHandler
			break
		end
	end
end

local function addState(SGname, state)
	 for k,v in pairs(GLOBAL.SGManager.instances) do	
		if(k.sg.name == SGname) then
			k.sg.states[state.name] =  state
			break
		end
	 end
end

addActionHandler("wilson", GLOBAL.ACTIONS.RECHARGE, "dolongaction")

addActionHandler("wilson", GLOBAL.ACTIONS.RESET, "reset")

local reset = GLOBAL.State{
        name = "reset",
        tags = {"doing"},
        
        onenter = function(inst, timeout)
            
            inst.sg:SetTimeout(timeout or 1)
            inst.components.locomotor:Stop()
            inst.SoundEmitter:PlaySound("dontstarve/rain/thunder_close", "make")
            
            inst.AnimState:PlayAnimation("build_pre")
            inst.AnimState:PushAnimation("build_loop", true)
        end,
        
        ontimeout= function(inst)
            inst.AnimState:PlayAnimation("build_pst")
            inst.sg:GoToState("idle", false)
            inst:PerformBufferedAction()
        
        end,
        
        onexit= function(inst)
            inst.SoundEmitter:KillSound("make")
        end, 
    }

    addState("wilson", reset)	

addActionHandler("wilson", GLOBAL.ACTIONS.MARK, "mark")

local mark = GLOBAL.State{
        name = "mark",
        tags = {"doing"},
        
        onenter = function(inst, timeout)
            
            inst.sg:SetTimeout(timeout or 1)
            inst.components.locomotor:Stop()
            inst.SoundEmitter:PlaySound("dontstarve/common/lightningrod", "make")
            
            inst.AnimState:PlayAnimation("build_pre")
            inst.AnimState:PushAnimation("build_loop", true)
        end,
        
        ontimeout= function(inst)
            inst.AnimState:PlayAnimation("build_pst")
            inst.sg:GoToState("idle", false)
            inst:PerformBufferedAction()
        
        end,
        
        onexit= function(inst)
            inst.SoundEmitter:KillSound("make")
        end, 
    }

    addState("wilson", mark)	

addActionHandler("wilson", GLOBAL.ACTIONS.RECALL, "recall")

local recall = GLOBAL.State{
        name = "recall",
        tags = {"doing"},
        
        onenter = function(inst)
            inst.components.locomotor:Stop()
            inst.AnimState:PlayAnimation("teleport")

			inst:DoTaskInTime(4.7, function(inst) inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_pulled") end )
        end,
        
		timeline =
        {
			GLOBAL.TimeEvent(19*GLOBAL.FRAMES, function(inst) inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_under") end),
		},

        events=
        {
            GLOBAL.EventHandler("animover", function(inst)
				inst:PerformBufferedAction()
				inst.sg:GoToState("idle") 
			end ),
        },
    }

	addState("wilson", recall)
	
end

AddSimPostInit(StoneSimPostInit)

function FiniteUsesPostInit(inst)
   function inst:FixStone(rechargevalue)
      inst:SetUses(inst.current + rechargevalue)
   end
   inst.inst:PushEvent("percentusedchange", {percent = inst:GetPercent()}) 
end

AddComponentPostInit("finiteuses", FiniteUsesPostInit)